// Run on an actual Desk page so you can get the CSRF token,
// like https://help.twitch.tv/admin
// or https://help.twitch.tv/agent
// otherwise the API will fail as unauthorized and terminate your session
// REQUIRES ACCESS TO DESK TEAM USER MANAGEMENT ADMIN PANEL
//
// The update payload itself goes here.
// It's a multi-line tsv of userID\tnewEmail\n, 
// basically copying those two columns straight out of a spreadsheet
// and pasting them between the backticks
// https://docs.google.com/spreadsheets/d/1GLz9ekVVyGZm4OIQQg74Aj8wuofEYVF2jfVUMt1Oe_Q/edit?ts=5a1485f7#gid=1576444081
// TODO: add error handling for payload not actually being TSV
var payload = `
`.trim(),                                                                         // trims the value so there's no hanging whitespace
  timers = [],                                                                    // hold the setTimeout timers so they can be cancelled in case of catestrophe
  userGroupStore = {},                                                            // hold the groups users are assigned to 
  update = payload                                                                // takes the multiline TSV in `payload`,
  .split('\n')                                                                    // splits it into an array of single line strings,
  .reduce((p, c, i, a) => {
    var split = c.split('\t');                                                    // splits each of those into an array of the key and its value,
    if (split[0] !== 'id' && !/#/.test(split[1])) {                               // makes sure it's not the header line from the spreadsheet or an invalid user,
      p[split[0]] = split[1];                                                     // and puts both in the accumulator that's returned at the end
    }
    return p
  }, {}),                                                                         // which is then assigned to `update`
  csrf = ($('meta[name="csrf-token"]').attr('content'));

function populateUsers(userGroupStore, total = 200) {

  console.log(`fetching users...`);                                               // more debugging prints
  return fetch(`/admin/team/users.handlebars?per_page=${total}&select_filter=`, { // string templating and es5 defaults make this easy 
      credentials: 'same-origin',                                                 // need to send cookies, not done by default
      method: 'GET',
      headers: {
        'Accept': 'application/json, text/javascript, */*;',
        'X-Requested-With': 'XMLHttpRequest',                                     // desk will  fail the request if you don't declare that it's via xhr :danthink:
        'X-CSRF-Token': csrf,                                                     // forgetting to include a csrf token will nuke your session 4head 
      },
    })
    .then((res) => {
      if (!res.ok) {
        console.log('user fetch error')
        return res                                                                // TODO: error handling
      }
      return res.json()                                                           // sends the json object to the next part of the chain
    })
    .then((d) => {
      d.users.forEach((e, i) => {                                                 // gotta loop through all of the users 
        userGroupStore[e.id] = e.groups.reduce((p, c, i, a) => {                  // and grab all of their group IDs to store up in the global object
          p.push(c.id);
          return p;
        }, []);
      });
      console.log('users fetched, groups stored by ID');
      return userGroupStore;
    });

}

function updateUser(userID, userGroupStore, email, timers, wait = 1, total) {

  let formData = new URLSearchParams(),                                           // easier to set up than string concat
    payload = {
      'utf8': '✓',                                                                // r a i l s
      '_method': 'put',                                                           // put is an in place update so we don't have to send all the data!
      'authenticity_token': csrf,                                                 // we have to send the csrf token twice!?
      'user[email]': email                                                        // the only part we're actually updating for the user is the email
    };

  for (paramName in payload) {
    formData.append(paramName, payload[paramName]);                               // adds them all to the query param / body
  }

  userGroupStore[userID].forEach((e, i) => {                                      // so we have to add the user's existing groups in the PUT,
    formData.append('user[group_ids][]', e);                                      // because Desk actually erases all of the groups if you don't?
  });                                                                             // it doesn't make a lot of sense 

  let timer = setTimeout(() => {                                                  // calls fetch inside a timeout so we don't make a billion requests at once
    fetch(`/admin/team/users/${userID}`,                                          // string templating makes this easy
        {
          credentials: 'same-origin',                                             // need to send cookies, not done by default
          method: 'POST',
          body: formData,                                                         // the params we created up above
          headers: {
            'Accept': 'application/json, text/javascript, */*;',
            'X-Requested-With': 'XMLHttpRequest',                                 // desk will  fail the request if you don't declare that it's via xhr :danthink:
            'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
            'X-CSRF-Token': csrf,                                                 // forgetting to include a csrf token will nuke your session 4head 
          },
        })
      .then((res) => {
        if (!res.ok) {
          return res                                                              // TODO: error handling. Desk will 422 on users you don't have access to update
        }
        return res.json()                                                         // // sends the json object to the next part of the chain
      })
      .then((d) => {
        console.log(`updated ${userID} to email ${d.users[0].email}`)             // you get the user object of the user you just updated, but parts of it are out of date in the object?
      })
  }, 1000 * wait);                                                                // we make the timer the current array index times 1 second
  timers.push(timer);                                                             // don't forget to actually put the timer reference somewhere so we can cancel it
  console.log(`Updating ${userID} in ${1000*wait} ms`);                           // more debugging prints

}

populateUsers(userGroupStore).then(() => {                                        // fetches the user list first, sets up the updates to occur on return

  Object.keys(update).forEach(function(id, index, array) {                        // loops through all the ids in the new `update` object
    let newEmail = update[id];                                                    // makes the email easier to get to
    updateUser(id, userGroupStore, newEmail, timers, index, array.length)         // calls the user update function for each user
  });

})
