# asg-instances-codedeploy
Simple ASG Spinup + CodeDeploy Agent

If you're using this, make sure you read and understand the codedeploy spinup instructions in https://git-aws.internal.justin.tv/d8a/codedeploy-app

### Inputs

* `account`: The AWS account to spin these resources up in (rather, the profile name to use to connect)
* `subnet_ids`: The VPC subnets to attach to the ASG
* `vpc_security_group_ids`: The SGs to attach to the ASG
* `service`: The service this hardware is part of (e.g. `graphite-web`, `my-cool-http-api`, etc)
* `role`: The role this ASG plays in `service` - vital if you have multiple ASGs in your service.
* `environment`: Environment the ELB lives in; `production`, `staging`, or `development`
* `ami`: The AMI instances of this ASG should be spun up with
* `owner`: The team the ASG and instances should be tagged as belonging to
* `sandstorm_assume_arn`: The Assume Role ARN for this ASG's Sandstorm role.

#### Optional
* `region`: Region to provision the ASG in, defaults to `us-west-2`
* `cluster`: The puppet cluster to configure this ASG's instances with.  Defaults to `role`.
* `instance_type`: What size of EC2 instance to use.  Defaults to `m4.large`.
* `puppet`: Which puppet server to use.  Defaults to `puppet`, can also be `puppet-ci`.
* `root_block_device_size`: What volume size to use for the root block device.  Defaults to `32`.
* `min_count`: Minimum ASG size.  Defaults to `1`.
* `max_count`: Maximum ASG size.  Defaults to `1`.
* `desired_capacity`: Desired ASG size.  Defaults to `1`.
* `load_balancers`: List of load balancers to attach to this ASG.  Defaults to an empty list.
* `deploy_group`: The name of the deploy group in your `codedeploy-app` that will deploy to this ASG.  Defaults to `main`.

### What Is Created

* An ASG with necessary artifacts (LC, Instance Profile, etc.)
* A role

### Outputs

* `asg_iam_role`: The ID of the created role
* `asg_iam_role_arn`: The ARN of the created role
* `asg_name`: The name of the created ASG
* `asg_arn`: The ARN of the created ASG
