# asg-routing
ELB &amp; R53 for ASGs - An alternative to `terraform-modules/elb` that plays nicely with ASGs. Creates a HTTPS only server with 80 to 443 redirect. You'll need to create your own DNS record to match the certificate you provide.

This module is only necessary because `terraform-modules/elb` accepts a manual list of instances which conflicts with ASG attachment.

### Inputs

* `account`: AWS account to create the ELB in.
* `environment`: Environment this ELB lives in; determines ELB name and DNS entry that points to the ELB
* `service`: Service that this ELB sits in front of (e.g. `graphite-web`, `my-cool-http-api`, etc)
* `port`: The port which the ELB listens on.
* `protocol`: The protocol (e.g. `http`, `https`, `tcp`, etc)
* `instance_port`: The port that traffic is forwarded to instances on.
* `instance_protocol`: The instance protocol (e.g. `http`, `https`, `tcp`, etc)
* `subnets` (list): The subnets (and thus availability zones) that this ELB should exist in
* `security_groups` (list): Security groups to apply to the ELB
* `instances` (list): List of instance ID's; puts these instances behind the ELB
* `certificate_arn`: ARN of ACM certificate for load balancer.

#### Optional
* `region`: Region to provision the ELB in, defaults to `us-west-2`

### What's Generated

* An ELB named `$service-$environment-elb`
* A DNS record for `$service.$environment_shortname.us-west2.justin.tv` pointing to the ELB
   * `$environment_shortname` is `prod`, `dev`, or `staging` for `production`, `development`, and `staging`, respectively
