#!/bin/bash

set -e

ACCOUNT=$1

case "$ACCOUNT" in
        development)
            ENVIRONMENTS=(dev)
            ;;
        *)
            echo "Unknown account \"$ACCOUNT\", exiting"
            exit 1
esac

for ENVIRONMENT in "${ENVIRONMENTS[@]}"
do
    ROLE=`terraform output -state=./terraform/${ACCOUNT}/.terraform/terraform.tfstate ${ENVIRONMENT}-iam_role_arn`

    tcs sandstorm role-flags \
        --owner team-data-eng \
        --name data-eng-${ENVIRONMENT}-buddy-spinup-test \
        --secret_key "data-eng/buddy-spinup-test/${ENVIRONMENT}/*" \
        --allowed_arn "${ROLE}" \
        --output ./sandstorm.d/${ACCOUNT}_${ENVIRONMENT}.json

done
