# Buddy
RDS management CLI and service

## Capabilities

Buddy has two components: a service which runs on a dedicated box and provides monitoring and management for your RDS clusters, and a CLI which can be run while SSH'd into the service instance.

### `buddy-cli clusters`

Lists all buddy-managed database clusters.

```
buddy@rds-buddy-data-eng-staging-00aba048cb6b835e2:/home/users/baynhams$ buddy-cli clusters
|         NAME          |                                     HOST                                      | DATABASE |
|-----------------------|-------------------------------------------------------------------------------|----------|
| cohesion_follow_games | cohesion-follow-games-staging-master.cifgffw7w2ar.us-west-2.rds.amazonaws.com | cohesion |
| cohesion_follows      | cohesion-follows-staging-master.cifgffw7w2ar.us-west-2.rds.amazonaws.com      | cohesion |
| cohesion_chat         | cohesion-chat-staging-master.cifgffw7w2ar.us-west-2.rds.amazonaws.com         | cohesion |
| cohesion_friends      | cohesion-friends-staging-master.cifgffw7w2ar.us-west-2.rds.amazonaws.com      | cohesion |
```

### `buddy-cli psql [cluster name] [optional: user name]`

Connects to the specified cluster as the specified user, with `psql`.  If no user is specified, the RDS superuser is used.

```
buddy@rds-buddy-data-eng-staging-00aba048cb6b835e2:/home/users/baynhams$ buddy-cli psql cohesion_follow_games site_01
Type "help" for help.

cohesion=> 
```

### `buddy-cli iceman [cluster name] ...`

Executes the iceman CLI against the specified cluster.  `buddy-cli iceman [cluster name] --help` can be used to show the iceman help screen,
  and the iceman `-e` and `-s` flags do not have to be specified, as buddy will provide them for you.  Other than that, simply specify the
  `iceman` CLI arguments after the cluster name.

```
buddy@rds-buddy-data-eng-staging-00aba048cb6b835e2:/home/users/baynhams$ buddy-cli iceman cohesion_follow_games status
[status -e staging]

Status for environment: staging

     Migration     ||          Created At          ||          Applied At          
===================================================================================

```

### Bulk Operation Management

The buddy service is capable of running pending iceman bulk operations peacemeal on a set schedule until
  they are complete.  Examples of how to set the bulk schedule can be seen [in the buddy install guide](https://twitchtv.atlassian.net/wiki/display/ENG/Manage+Your+RDS+Instances+With+Buddy).
  You can view the status of iceman bulk operations by visiting `<your buddy server>:8000/status/bulk`.

### Automatic Iceman Configuration

When buddy is set up by puppet, iceman repositories for each of your managed clusters will be verified and, if necessary, configured.  At the end of the buddy
  provisioning process, you will be able to seamlessly write, review, and deploy schema and bulk data changes via iceman.

### Automatic Sandstorm Configuration

When buddy is set up by puppet, the state of the users in your managed cluster will be synched from puppet and sandstorm, ensuring that the database passwords
  match the secrets in sandstorm.
