package configuration

import (
	"code.justin.tv/d8a/buddy/cmd/buddy-cli/data"
	"github.com/spf13/cobra"
)

var ConfigureCmd = &cobra.Command{
	Use:   "configure",
	Short: "Configure cluster properties.",
}

var cmdProfile string
var cmdRegion string

func init() {
	ConfigureCmd.PersistentFlags().StringVarP(&cmdRegion, "region", "r", "us-west-2", "region for AWS sessions")
	ConfigureCmd.PersistentFlags().StringVarP(&cmdProfile, "profile", "p", "", "name of AWS profile in config")
	ConfigureCmd.PersistentPreRunE = func(command *cobra.Command, args []string) error {
		return data.PopulateConfigData(command, args)
	}
}
