package configuration

import (
	"fmt"

	"code.justin.tv/d8a/buddy/cmd/buddy-cli/data"
	"code.justin.tv/d8a/buddy/lib/clusters/clusterdb"
	"code.justin.tv/d8a/buddy/lib/store"
	"github.com/pkg/errors"
	"github.com/spf13/cobra"
)

var dbname = &cobra.Command{
	Use:   "dbname [cluster] [dbname]",
	Short: "Change the managed database name for a cluster",
	Long:  "Change the managed database name for a cluster",
	RunE: func(command *cobra.Command, args []string) error {
		if len(data.ConfigureData.Args()) != 1 {
			return command.Usage()
		}

		dbname := data.ConfigureData.Args()[0]

		foundCluster := data.ConfigureData.FoundCluster()

		if foundCluster.Database == dbname {
			fmt.Println("No change")
			return nil
		}

		foundCluster.Database = dbname

		_, err := clusterdb.OpenDbConn(foundCluster, data.ConfigureData.SandstormClient(), foundCluster.SuperUser)
		if err != nil {
			return errors.Wrap(err, fmt.Sprintf("couldn't open a connection to the provided database %s with superuser %s", dbname, foundCluster.SuperUser))
		}

		return store.UpdateDBName(data.ConfigureData.StoreDB(), foundCluster)
	},
}

func init() {
	ConfigureCmd.AddCommand(dbname)
}
