package configuration

import (
	"fmt"

	"code.justin.tv/d8a/buddy/cmd/buddy-cli/data"
	"code.justin.tv/d8a/buddy/lib/store"
	"github.com/spf13/cobra"
)

var rolePairRemove = &cobra.Command{
	Use:   "remove-role-pair [cluster] [role name]",
	Short: "Remove a role pair from the cluster",
	Long:  "Remove a role pair from the cluster in the buddy store, but not anywhere else",
	RunE: func(command *cobra.Command, args []string) error {
		if len(data.ConfigureData.Args()) != 1 {
			return command.Usage()
		}

		foundCluster := data.ConfigureData.FoundCluster()

		rolePair := foundCluster.GetRolePair(data.ConfigureData.Args()[0])
		if rolePair == nil {
			return fmt.Errorf("could not find role pair %s in cluster %s", data.ConfigureData.Args()[0], foundCluster.Name)
		}

		err := store.DeleteRolePair(data.ConfigureData.StoreDB(), rolePair)
		if err != nil {
			return err
		}

		fmt.Println("Role pair deleted- this did not do anything at all to the users in the database, just in case you still need them for something!")
		return nil
	},
}

func init() {
	ConfigureCmd.AddCommand(rolePairRemove)
}
