package configuration

import (
	"fmt"

	"code.justin.tv/d8a/buddy/cmd/buddy-cli/data"
	"code.justin.tv/d8a/buddy/lib/store"
	"github.com/spf13/cobra"
)

var roleServiceRemove = &cobra.Command{
	Use:   "remove-role-service [cluster] [role name] [service name]",
	Short: "Remove a role service from the role pair",
	Long:  "Remove a role service from the role pair in the buddy store, but not anywhere else",
	RunE: func(command *cobra.Command, args []string) error {
		if len(data.ConfigureData.Args()) != 2 {
			return command.Usage()
		}

		foundCluster := data.ConfigureData.FoundCluster()

		rolePair := foundCluster.GetRolePair(data.ConfigureData.Args()[0])
		if rolePair == nil {
			return fmt.Errorf("could not find role pair %s in cluster %s", data.ConfigureData.Args()[0], foundCluster.Name)
		}

		roleService := rolePair.GetService(data.ConfigureData.Args()[1])
		if roleService == nil {
			return fmt.Errorf("could not find role service %s in role pair %s", data.ConfigureData.Args()[1], rolePair.Name)
		}

		err := store.DeleteRoleService(data.ConfigureData.StoreDB(), roleService)
		if err != nil {
			return err
		}

		return nil
	},
}

func init() {
	ConfigureCmd.AddCommand(roleServiceRemove)
}
