package info

import (
	"fmt"

	"code.justin.tv/d8a/buddy/cmd/buddy-cli/setup"

	"github.com/spf13/cobra"
)

var airflowDataCmd = &cobra.Command{
	Use:   "airflow-data [sqlalchemy|celery-broker|celery-result]",
	Short: "Display dynamic information for airflow to use in processing zenyatta dags",
	Long:  "Display one of 3 pieces of information: airflow-data sqlalchemy displays a connection string to the airflow database in the buddy store, airflow-data celery-broker and airflow-data celery-result will display a connection string to their respective redis databases",
	RunE: func(command *cobra.Command, args []string) error {
		if len(args) != 1 {
			return command.Usage()
		}

		if args[0] == "sqlalchemy" {
			txt, err := setup.AirflowSqlalchemyConnection()
			fmt.Println(txt)
			return err
		}

		if args[0] == "celery-broker" || args[0] == "celery-result" {
			txt, err := setup.AirflowRedisConnection()
			fmt.Println(txt)
			return err
		}

		fmt.Println()
		return nil
	},
}

func init() {
	setup.RootCmd.AddCommand(airflowDataCmd)
}
