package info

import (
	"fmt"
	"os"

	"code.justin.tv/d8a/buddy/cmd/buddy-cli/data"
	"code.justin.tv/d8a/buddy/cmd/buddy-cli/setup"
	"code.justin.tv/d8a/buddy/lib/store"

	"github.com/olekukonko/tablewriter"
	"github.com/spf13/cobra"
)

var usersCmd = &cobra.Command{
	Use:   "users [cluster]",
	Short: "Show managed database users",
	Long:  "Show managed database users",
	RunE: func(command *cobra.Command, args []string) error {
		rdsInstance, err := data.RootData.LocateDataStore(false)
		if err != nil {
			return err
		}

		db, err := store.OpenDbConn(rdsInstance, data.RootData.SandstormClient())
		if err != nil {
			return err
		}

		fmt.Println("Retrieving users")
		data.RootData.ConfigFile().Cluster, err = store.GetClusters(db)
		if err != nil {
			return err
		}
		fmt.Println("Users retrieved")

		table := tablewriter.NewWriter(os.Stdout)
		table.SetHeader([]string{"Name", "Secret", "Cluster"})
		table.SetBorders(tablewriter.Border{Left: true, Top: false, Right: true, Bottom: false})
		table.SetCenterSeparator("|")

		foundCluster := false
		for _, cluster := range data.RootData.ConfigFile().Cluster {
			if len(args) == 0 || cluster.Name == args[0] {
				foundCluster = true
				for _, user := range cluster.User {
					table.Append([]string{user.Name, user.Secret, cluster.Name})
				}
			}
		}

		if foundCluster {
			table.Render()
		} else if len(args) > 0 {
			return fmt.Errorf("There is no cluster named %s.  Did you forget to tag your instances?", args[0])
		}

		return nil
	},
}

func init() {
	setup.RootCmd.AddCommand(usersCmd)
}
