package setup

import (
	"code.justin.tv/d8a/buddy/cmd/buddy-cli/configuration"
	"code.justin.tv/d8a/buddy/cmd/buddy-cli/data"

	"github.com/spf13/cobra"
)

var (
	cmdRegion  string
	cmdProfile string
)

var RootCmd = &cobra.Command{
	Use:           "buddy",
	Short:         "RDS management utility",
	Long:          `Set up and execute service utilities for RDS clusters.`,
	SilenceErrors: true,
	SilenceUsage:  true,
}

func init() {
	RootCmd.PersistentFlags().StringVarP(&cmdRegion, "region", "r", "us-west-2", "region for AWS sessions")
	RootCmd.PersistentFlags().StringVarP(&cmdProfile, "profile", "p", "", "name of AWS profile in config")
	RootCmd.PersistentPreRunE = func(cmd *cobra.Command, args []string) error {
		return data.PopulateRootData(cmd, args)
	}
	RootCmd.AddCommand(configuration.ConfigureCmd)
}
