package utils

import (
	"fmt"
	"os"
	"os/exec"
	"strconv"

	"code.justin.tv/d8a/buddy/cmd/buddy-cli/data"
	"code.justin.tv/d8a/buddy/cmd/buddy-cli/setup"

	"github.com/spf13/cobra"
)

var ()

var psqlStoreCmd = &cobra.Command{
	Use:   "psql-store",
	Short: "Launch psql to connect to the specified cluster",
	Long:  "Is equivalent to running psql, but the connection information and password are retrieved seamlessly.  If user is not specified, the superuser for the cluster is used.",
	RunE: func(command *cobra.Command, args []string) error {
		if len(args) != 0 {
			return command.Usage()
		}

		rdsInstance, err := data.RootData.LocateDataStore(false)
		if err != nil {
			return err
		}

		password, err := data.RootData.SandstormClient().GetStorePassword()
		if err != nil {
			return err
		}

		env := os.Environ()
		env = append(env, fmt.Sprintf("PGPASSWORD=%s", password))

		cmd := exec.Command("psql", "-h", *rdsInstance.Endpoint.Address, "-p", strconv.Itoa(int(*rdsInstance.Endpoint.Port)), "-d", *rdsInstance.DBName, "-U", *rdsInstance.MasterUsername, "-w")
		cmd.Stderr = os.Stderr
		cmd.Stdin = os.Stdin
		cmd.Stdout = os.Stdout
		cmd.Env = env

		return cmd.Run()
	},
}

func init() {
	setup.RootCmd.AddCommand(psqlStoreCmd)
}
