package api

import (
	"database/sql"

	"code.justin.tv/common/twitchhttp"
	"code.justin.tv/d8a/buddy/lib/bulk"
	"code.justin.tv/d8a/buddy/lib/config"
	"code.justin.tv/d8a/buddy/lib/sandstorm"
	"goji.io"
	"goji.io/pat"
)

type ServerExt struct {
	config   *config.ConfigFile
	schedule *bulk.Schedule
	cache    *bulk.BulkRecordStore

	sandstormClient sandstorm.SandstormAPI
	storeDb         *sql.DB
}
type Server struct {
	*goji.Mux
	*ServerExt
}

func NewServer(configFile *config.ConfigFile, schedule *bulk.Schedule, cache *bulk.BulkRecordStore, storeDb *sql.DB, sandstormClient sandstorm.SandstormAPI) (*Server, error) {
	server := twitchhttp.NewServer()

	s := &Server{
		server,
		&ServerExt{
			config:   configFile,
			schedule: schedule,
			cache:    cache,

			sandstormClient: sandstormClient,
			storeDb:         storeDb,
		},
	}
	s.HandleFuncC(pat.Get("/status/bulk"), s.BulkStatus)
	s.HandleFuncC(pat.Get("/status/secrets"), s.SecretStatus)
	s.HandleFuncC(pat.Get("/status/pairs"), s.PairStatus)

	return s, nil
}
