freeStyleJob('d8a-buddy') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'd8a/buddy', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'manta -proxy && mkdir -p pkgs'
    fpmPackageFromDir 'deb', '.manta'
    shell "mv buddy_*_amd64.deb pkgs/buddy.deb" // name it something we can fetch easily later
    shell "sed -i.bak 's/buddy/buddy-staging/g' fpm_scripts/NAME"
    fpmPackageFromDir 'deb', '.manta'
    shell "mv buddy-staging_*_amd64.deb pkgs/buddy-staging.deb" // name it something we can fetch easily later
    saveDeployArtifact 'd8a/buddy', 'pkgs'
  }
}

freeStyleJob('d8a-buddy-aptly') {
    parameters {
        stringParam 'GIT_COMMIT'
    }
    steps {
        downloadDeployArtifact 'd8a/buddy'
        uploadDeb 'buddy.deb', 'xenial'
    }
    wrappers {
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'dta_tools_deploy', 'dta_tools_deploy'
        }
    }
}

freeStyleJob('d8a-buddy-staging-aptly') {
    parameters {
        stringParam 'GIT_COMMIT'
    }
    steps {
        downloadDeployArtifact 'd8a/buddy'
        uploadDeb 'buddy-staging.deb', 'xenial'
    }
    wrappers {
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'dta_tools_deploy', 'dta_tools_deploy'
        }
    }
}

