package awsutil

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
)

// GetSession will pull a working config & live AWS API session from the given region & profile
// Region must be filled with a valid AWS region, but profile can be left blank (in which case,
// auth with the instance's role will be attempted)
func GetSession(region string, profile string, retries int) (*aws.Config, *session.Session, error) {
	config := &aws.Config{
		Region:     aws.String(region),
		MaxRetries: aws.Int(retries),
	}

	if profile == "" {
		return config, session.New(config), nil
	}

	session, err := session.NewSessionWithOptions(session.Options{
		Config:  *config,
		Profile: profile,
	})
	return config, session, err
}
