package config

import (
	"text/template"
	"fmt"
	"bytes"
	"code.justin.tv/d8a/buddy/lib/config/templates"
)


type AirflowConfig struct {
	S3LogPath		string
	RDSUser			string
	RDSPassword		string
	RDSHost			string
	FernetKey		string
	EmailUser		string
	EmailPassword		string
	AlertEmail		string
	RedisHost		string
	WorkerAMI		string
	WorkerEBSVolumeSize	int
	Parallelism		int
	MaxTasks		int
	WebServerWorkerNum	int
	Authenticate		bool
}


func (config *AirflowConfig) GenerateConfig() (string, error) {
	var output bytes.Buffer
	templateText, err := templates.Asset("templates/airflow.cfg.tmpl")
	if err != nil {

		return "", fmt.Errorf("error loading asset via go-bindata templates/airflow.cfg.tmpl: %v", err)
	}
	tmpl , err := template.New("airflow.cfg").Parse(string(templateText))
	if err != nil {
		return "", fmt.Errorf("error parsing template: %v", err)
	}
	err = tmpl.Execute(&output, config)
	if err != nil {
		return "" ,fmt.Errorf("error injecting AirflowConfig into template: %v", err)
	}
	return output.String(), nil
}

