package config_test


import (
	"testing"
	"strings"
	"code.justin.tv/d8a/buddy/lib/config"
)

func substringCheck(t *testing.T, theString string, theSubstring string) {
	if !strings.Contains(theString, theSubstring) {
		t.Fatal("config missing: ", theSubstring)
	}
}



func TestAirflowConfig_GenerateConfig(t *testing.T) {
	config := config.AirflowConfig{
		S3LogPath: "s3://lul",
		RDSUser: "airflow",
		RDSPassword: "airflow1234",
		RDSHost: "airflow.amazon.com",
		FernetKey: "1234",
		EmailUser: "airflow",
		EmailPassword: "1234",
		AlertEmail: "airflow@buddy.com",
		RedisHost: "redis.amazon.com",
		WorkerAMI: "ami-1234",
		WorkerEBSVolumeSize: 1000,
		Parallelism: 16,
		MaxTasks: 256,
		WebServerWorkerNum: 4,
		Authenticate: false,
	}

	configString, _ := config.GenerateConfig()
	// sanity check that the first item makes it in there
	substringCheck(t, configString, "airflow_home = /etc/zenyatta")
	substringCheck(t, configString, "remote_base_log_folder = s3://lul")
	substringCheck(t, configString, "sql_alchemy_conn = postgresql://airflow:airflow1234@airflow.amazon.com:5432/airflow")
	substringCheck(t, configString, "parallelism = 16")
	substringCheck(t, configString, "dag_concurrency = 256")
	substringCheck(t, configString, "smtp_mail_from = airflow@buddy.com")
	substringCheck(t, configString, "fernet_key = 1234")
	substringCheck(t, configString, "worker_ami = ami-1234")
	substringCheck(t, configString, "ebs_size = 1000")
	substringCheck(t, configString, "broker_url = redis://redis.amazon.com:6379")
	substringCheck(t, configString, "celery_result_backend = redis://redis.amazon.com:6379")
	substringCheck(t, configString, "smtp_user = airflow")
}

