package config

import (
	"testing"

	"github.com/naoina/toml"
	"github.com/stretchr/testify/require"
)

func buildConfig() string {
	return `SlackRoom = "d8a"
SandstormRole = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/rds_sandstorm_data-eng_staging"
	`
}

func parseConfig(t *testing.T) *ConfigFile {
	config := buildConfig()

	configFile := &ConfigFile{}
	err := toml.Unmarshal([]byte(config), configFile)
	require.Nil(t, err)
	return configFile
}

func TestParseConfig(t *testing.T) {
	config := parseConfig(t)
	require.NotNil(t, config)
	require.Equal(t, "d8a", config.SlackRoom)
	require.Equal(t, "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/rds_sandstorm_data-eng_staging", config.SandstormRole)
	require.Len(t, config.Cluster, 0)
}
