package store

import (
	"testing"

	"code.justin.tv/d8a/iceman/lib/migrations"

	"github.com/stretchr/testify/require"
	yaml "gopkg.in/yaml.v2"
)

func TestMigrationRecords(t *testing.T) {
	require.NotNil(t, migrationSource)
	migrationRecords, err := migrationSource.FetchAllMigrations()
	require.Nil(t, err)
	require.True(t, len(migrationRecords) >= 2)

	migration := &migrations.Migration{}
	err = yaml.Unmarshal(migrationRecords[0].Content, migration)
	require.Nil(t, err)
	require.NotNil(t, migration)
	require.NotNil(t, migration.Down)
	require.NotNil(t, migration.Up)
	require.True(t, len(migration.Up.Operations) > 0)
	require.True(t, len(migration.Down.Operations) > 0)
}
