package store

import (
	"database/sql"

	"code.justin.tv/d8a/buddy/lib/config"
)

type dbRoleService struct {
	id             int
	name           string
	usernameSecret string
	passwordSecret string
	rolePairId     int
}

func readRoleServices(db *sql.DB) ([]*dbRoleService, error) {
	var clusterServices []*dbRoleService
	rows, err := db.Query("SELECT id, name, username_secret, password_secret, role_pair_id FROM role_services")
	if err != nil {
		return clusterServices, err
	}

	defer TryClose(rows)

	for rows.Next() {
		service, err := readRoleService(rows)
		if err != nil {
			return clusterServices, err
		}
		clusterServices = append(clusterServices, service)
	}

	return clusterServices, nil
}

func readRoleService(rows *sql.Rows) (*dbRoleService, error) {
	var id, rolePairId int
	var name, usernameSecret, passwordSecret string
	err := rows.Scan(&id, &name, &usernameSecret, &passwordSecret, &rolePairId)
	if err != nil {
		return nil, err
	}

	return &dbRoleService{
		id:             id,
		name:           name,
		usernameSecret: usernameSecret,
		passwordSecret: passwordSecret,
		rolePairId:     rolePairId,
	}, nil
}

func InsertRoleService(db *sql.DB, pair *config.RolePair, service *config.RoleService) error {
	_, err := db.Exec("INSERT INTO role_services (name, username_secret, password_secret, role_pair_id) VALUES ($1, $2, $3, $4)", service.Name, service.UsernameSecret, service.PasswordSecret, pair.Id)
	return err
}

func UpdateRoleService(db *sql.DB, service *config.RoleService) error {
	_, err := db.Exec("UPDATE role_services SET name=$1, username_secret=$2, password_secret=$3 WHERE id=$4", service.Name, service.UsernameSecret, service.PasswordSecret, service.Id)
	return err
}

func DeleteRoleService(db *sql.DB, service *config.RoleService) error {
	_, err := db.Exec("DELETE FROM role_services WHERE id=$1", service.Id)
	return err
}
