package templates

import (
	"text/template"
	"bytes"
	"fmt"
	"code.justin.tv/d8a/buddy/lib/terraform/templates"
)

/*
Example
s3arns := `"arn:aws:s3:::twitch-web-dev*",
		   "arn:aws:s3:::twitch-web-dev/*",
		   "arn:aws:s3:::twitch-d8a-test*",
		   "arn:aws:s3:::twitch-d8a-test/*",
		   "arn:aws:s3:::twitch-d8a-etl/*",
		   "arn:aws:s3:::science-input/dbsnapshots*",
		   "arn:aws:s3:::science-input/dbsnapshots/*"`

z := ZenyattaTerraform{
	DnsProfile:  "twitch-aws",
	InfraProfile: "twitch-web-dev",
	Region: "us-west-2",
	Service: "lyons",
	Environment: "development",
	Owner: "michlyon",
	VpcId: "vpc-230f5e46",
	ZoneId: "ZRG00SM48517Z",
	InstanceType: "m4.xlarge",
	Ami: "ami-a66dccc6",
	RdsIdentifier: "lyons-test2",
	RdsUsername: "lyons",
	RdsPassword: "lyons12345678",
	RdsSubnetGroupName: "d8a-subnet-group",
	SandstormRole: "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/airflow-development",
	S3Arns: s3arns,
	SubnetIds: "subnet-b1af88d4\",\"subnet-1d76336a\",\"subnet-cbd54a92",
	SubnetCidrs:  "10.0.0.0/8\",\"127.0.0.1/32\",\"192.168.0.0/16",
	AvailabilityZones: "us-west-2a\",\"us-west-2c",
	WorkerCount: 1,
	EbsSize: 200,
} */

type ZenyattaTerraform struct {
	DnsProfile		string
	InfraProfile		string
	Region			string
	Service 		string
	Environment 		string
	Owner 			string
	VpcId			string
	ZoneId			string
	InstanceType 		string
	Ami			string
	RdsIdentifier 		string
	RdsUsername		string
	RdsPassword		string
	RdsSubnetGroupName	string
	SandstormRole		string
	SubnetIds		string
	SubnetCidrs		string
	AvailabilityZones	string
	S3Arns			string
	WorkerCount		int
	EbsSize			int
}

func (config *ZenyattaTerraform) GenerateTemplate() (string, error) {
	var output bytes.Buffer
	templateText, err := templates.Asset("templates/zenyatta.tf")
	if err != nil {
		return "", fmt.Errorf("error loading asset via go-bindata templates/zenyatta.tf: %v", err)
	}
	tmpl , err := template.New("zenyatta.tf").Parse(string(templateText))
	if err != nil {
		return "", fmt.Errorf("error parsing template: %v", err)
	}
	err = tmpl.Execute(&output, config)
	if err != nil {
		return "" ,fmt.Errorf("error injecting ZenyattaTerraform into template: %v", err)
	}
	return output.String(), nil
}


