package zenyatta

import (
	"os"
	"fmt"
	"os/exec"
	"github.com/pkg/errors"
	"code.justin.tv/d8a/buddy/lib/awsutil"
	"github.com/aws/aws-sdk-go/service/ec2/ec2iface"
	"github.com/aws/aws-sdk-go/service/ec2"
)


func ZenyattaEnvironment() ([]string, error) {
	env := os.Environ()

	zenyattaHome := "/etc/zenyatta"
	env = append(env, fmt.Sprintf("AIRFLOW_HOME=%s", zenyattaHome))

	return env, nil
}

func StartZenyattaWorker(teamName string, region string, environment string, key string) error {

	cmd := exec.Command("/opt/virtualenvs/airflow/bin/python",
		"/opt/twitch/zenyatta/current/scripts/setup_worker.py",
		"--name", teamName,
		"--region", region,
		"--env", environment,
		"--key", key)
	env, err := ZenyattaEnvironment()
	if err != nil {
		return err
	}
	cmd.Env = env
	cmd.Stderr = os.Stderr
	cmd.Stdin = os.Stdin
	cmd.Stdout = os.Stdout
	err = cmd.Run()
	if err != nil {
		return errors.Wrap(err, "failed to run setup_worker.py script")
	}

	return nil
}

func TerminateZenyattaWorker(ec2Client ec2iface.EC2API, name string) error {
	// find instance
	instance, err := awsutil.FetchInstance(ec2Client, name, "running")
	if err != nil {
		return err
	}
	fmt.Println(fmt.Sprintf("found instance: %s", *instance.InstanceId))
	// terminate instance
	err = awsutil.TerminateInstance(ec2Client, instance)
	if err != nil {
		fmt.Println(fmt.Sprintf("%s seems to have failed to terminate due to: %s", *instance.InstanceId, err.Error()))
		return err
	}
	fmt.Println(fmt.Sprintf("waiting on %s to terminate", *instance.InstanceId))

	err = ec2Client.WaitUntilInstanceTerminated(&ec2.DescribeInstancesInput{
		InstanceIds: []*string{instance.InstanceId},
	})
	if err != nil {
		fmt.Println(fmt.Sprintf("failed to wait on %s to terminate due to: %s", *instance.InstanceId, err.Error()))
	}
	return err
}
