require 'aws_service'

class SnapshotsController < ApplicationController

skip_before_action :verify_authenticity_token
  def create
    @snapshot = Snapshot.new(snapshot_params)
    @snapshot.save

  end

  def new
    @snapshot = Snapshot.new
  end

  def show
    @databases = Database.select('DISTINCT name')
    @database = Database.where(name: params[:id], db_type: params[:db_type]).limit(1)
    @snapshots = Snapshot.where(id: params[:id], database_name: params[:database_name], database_type: params[:database_type])
  end

  def rds_input
    sqs_message_response= AwsService.new.sqs_receive_message_queue
    database_name = sqs_message_response[:database]
    s3_url = sqs_message_response[:s3_url]
    db_type = sqs_message_response[:db_type]
    collection_timestamp = sqs_message_response[:date_stamp]
    csv_url = sqs_message_response[:csv_url]
    new_params = {"database_name" => database_name, "s3_url" => s3_url, "database_type" => db_type, "collection_timestamp" => collection_timestamp, "csv_url" => csv_url }
    db_params = {"name" => database_name, "db_type" => db_type}
    if !Database.find_by(db_params)
      @database = Database.new(db_params)
      @database.save
    end

    Snapshot.create!(new_params)

  end

  def destroy
    @snapshot = Snapshot.find((params[:id]))
    if @snapshot.present? 
      @snapshot.destroy
    end
    respond_to do |format|
      format.html { redirect_to databases_path, notice: 'Snapshot was successfully destroyed.' }
      format.json { head :no_content }
    end
  end

  private
    def snapshot_params
      params.require(:snapshot).permit(:s3_url, :database_name, :database_type, :collection_timestamp)
    end

end