class Database < ActiveRecord::Base
  extend FriendlyId
  friendly_id :name, use: :slugged, slug_column: :name
  has_many :snapshots, primary_key: :name, foreign_key: :database_name
  validates :name, :presence => true, :uniqueness => true

end
