require 'aws-sdk'
require 'json'
require 'logger'
require 'shoryuken'

class AwsService
  #performs the sqs message receival

  def sqs_receive_message_queue()
    # logger = Logger.new('var/clio.log')
    # logger.level = Logger::WARN
    queue_url = 'https://sqs.us-west-2.amazonaws.com/673385534282/Clio_RDS_Update'
    # queue_url = 'https://sqs.us-west-2.amazonaws.com/673385534282/Clio_Test'
    sqs = Aws::SQS::Client.new(region: 'us-west-2')
    s3 = Aws::S3::Client.new(region: 'us-west-2')
    message_attributes = [ "date_stamp", "database", "fqdn", "s3_path", "schema", "s3filename", "s3_url", "db_type" ]
    resp = sqs.receive_message({
      queue_url: queue_url,
      message_attribute_names: message_attributes,
      max_number_of_messages: 1,
      visibility_timeout: 3,
      wait_time_seconds: 1,
      })

    begin
      date_stamp = resp.messages[0].message_attributes["date_stamp"].string_value
      s3_url = resp.messages[0].message_attributes["s3_url"].string_value
      s3Path = resp.messages[0].message_attributes["s3_path"].string_value
      fqdn = resp.messages[0].message_attributes["fqdn"].string_value
      s3filename = resp.messages[0].message_attributes["s3filename"].string_value
      database = resp.messages[0].message_attributes["database"].string_value
      db_type = resp.messages[0].message_attributes["db_type"].string_value
      schema = resp.messages[0].message_attributes["schema"].string_value

    rescue
      # logger.warn("Message Attribute is null in SQS message")
      abort("Message Attribute is null in SQS message")
      exit
    end 
    csv_s3_path = "clio/"+database+"/"+schema+"/"+db_type+"/"+fqdn+"/"+date_stamp+"/OUTPUT/project/logs/"
    key_path = s3.list_objects({bucket: "d8a", prefix: csv_s3_path})
    url_prefix = 'https://s3-us-west-2.amazonaws.com/'
    csv_url = url_prefix + "d8a/" + key_path.contents[0].key
    receipt_handle = resp.messages[0].receipt_handle
    delete_sqs_message(sqs, queue_url, receipt_handle)
    
    response = { :date_stamp => date_stamp, :s3Path => s3Path, :s3filename => s3filename, :database => database, :s3_url => s3_url, :db_type => db_type, :schema => schema, :csv_url => csv_url}

  end

  def queue_dc(database, database_type, fqdn, schema, time)
    queue_url = 'https://sqs.us-west-2.amazonaws.com/673385534282/Clio_Queue_DataCollection'
    sqs = Aws::SQS::Client.new(region: 'us-west-2')
    message_attributes = {
              "fqdn" => {
                  :string_value => fqdn,
                  :data_type => 'String'
              },
              "schema"  => {
                  :string_value => schema,
                  :data_type => 'String'
              },
              "database" =>  {
                  :string_value => database,
                  :data_type => 'String'
              },
              "db_type" =>  {
                  :string_value => database_type,
                  :data_type => 'String'
              },
              "time" => {
                  :string_value => time,
                  :data_type => 'String'
              }
            }
    resp = sqs.send_message({
        queue_url:  queue_url, 
        message_body:  "Queue Data Collection", # required
        message_attributes:  message_attributes,
      })
    return resp
  end

  def list_bucket_objects(csv_s3_path)
    s3 = Aws::S3::Client.new(region: 'us-west-2')
    bucket_name = "d8a"
    s3_object = s3.list_objects({
      bucket: bucket_name,
      prefix: csv_s3_path,
      })
    return s3_object.name+"/"+s3_object.contents[0].key
  end

  # def queue_datacollection(database, database_type, fqdn, schema, time)
  #   sns = Aws::SNS::Client.new(region: 'us-west-2')
  #   params = { 
  #       :topic_arn => "arn:aws:sns:us-west-2:673385534282:Clio_Datacollection",
  #       :message => "queue from clio", 
  #       :message_attributes => {
  #             "fqdn" => {
  #                 :string_value => fqdn,
  #                 :data_type => 'String'
  #             },
  #             "schema"  => {
  #                 :string_value => schema,
  #                 :data_type => 'String'
  #             },
  #             "database" =>  {
  #                 :string_value => database,
  #                 :data_type => 'String'
  #             },
  #             "db_type" =>  {
  #                 :string_value => database_type,
  #                 :data_type => 'String'
  #             },
  #             "time" => {
  #                 :string_value => time,
  #                 :data_type => 'String'
  #             }
  #       }
  #     }
  #     response = sns.publish(params)
  #     return response
  # end

  def new (*args)
    sqs = Aws::SQS::Client.new(region: 'us-west-2' )
  end 

  private

  def delete_sqs_message(sqs, queue_url, receipt_handle)
    resp = sqs.delete_message(queue_url: queue_url, receipt_handle: receipt_handle)
  end

  # used for testing sending messages

  def sqs_send_message()
    queue_url = 'https://sqs.us-west-2.amazonaws.com/673385534282/Clio_RDS_Update'
    sqs = Aws::SQS::Client.new(region: 'us-west-2')
    
    message_attributes = { "date_stamp" => {:string_value => "test date_stamp", :data_type => "String",},  "s3Path" => {:string_value => "test s3Path", :data_type => "String",},  "s3filename" => {:string_value => "test s3filename", :data_type => "String",},  "end_time" => {:string_value => "test end_time", :data_type => "String",},  "database" => {:string_value => "test database", :data_type => "String",} }
    
    resp = sqs.send_message({queue_url: queue_url, message_body: "String", message_attributes: message_attributes})
  end

end
