job {
  name 'd8a-clio-build'
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'd8a/clio', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
    }
  }
  steps {
    shell 'rm -rf .manta/'
    shell 'manta -v -proxy'
    saveDeployArtifact 'd8a/clio', '.manta/'
  }
}

job {
  name 'd8a-clio-deploy'
  using 'TEMPLATE-deploy'
  steps {
    downloadDeployArtifact "d8a/clio"
    shell 'update-deployed-version -repo d8a/clio'
    shell 'courier deploy --repo d8a/clio --dir /opt/twitch/clio'
  }
}
