data "aws_iam_policy_document" "secondary_codedeploy_trust" {
    provider = "aws.secondary"

    statement {
        actions = ["sts:AssumeRole"]

        principals {
            type = "AWS"
            identifiers = ["${var.main_data["deployer_user_arn"]}"]
        }
    }
}

data "aws_iam_policy_document" "secondary_codedeploy_policy_doc" {
    provider = "aws.secondary"

    statement {
        actions = [
            "codedeploy:List*",
            "codedeploy:Get*",
            "codedeploy:CreateDeployment",
            "codedeploy:RegisterApplicationRevision"
        ]
        resources = ["*"]
    }
}

resource "aws_iam_policy" "secondary_codedeploy_policy" {
    provider = "aws.secondary"

    name = "${var.main_data["bucket_name"]}-actor-deploy"
    policy = "${data.aws_iam_policy_document.secondary_codedeploy_policy_doc.json}"
}

resource "aws_iam_role" "deployment_role" {
    provider = "aws.secondary"

    name = "${var.main_data["bucket_name"]}-actor"
    assume_role_policy = "${data.aws_iam_policy_document.secondary_codedeploy_trust.json}"
}

resource "aws_iam_role_policy_attachment" "deployment_role_attachment" {
    provider = "aws.secondary"

    role = "${aws_iam_role.deployment_role.name}"
    policy_arn = "${aws_iam_policy.secondary_codedeploy_policy.arn}"
}

data "aws_iam_policy_document" "deployer_user_assume_policy_doc" {
    provider = "aws.main"

    statement {
        actions = ["sts:AssumeRole"]
        resources = ["${aws_iam_role.deployment_role.arn}"]
    }
}

resource "aws_iam_policy" "deployer_user_assume_policy" {
    provider = "aws.main"

    name = "${var.main_data["bucket_name"]}-actor-assume-${var.secondary_account}"
    policy = "${data.aws_iam_policy_document.deployer_user_assume_policy_doc.json}"
}

resource "aws_iam_user_policy_attachment" "deployer_user_assume_attachment" {
    provider = "aws.main"

    user = "${var.main_data["deployer_user"]}"
    policy_arn = "${aws_iam_policy.deployer_user_assume_policy.arn}"
}

output "deploy_role_arn" {
    value = "${aws_iam_role.deployment_role.arn}"
}
