# elb-ssl
Simple ELB (SSL) creation, with A record in twitch-aws route53

### Inputs

* `account`: AWS account to create the ELB in.
* `environment`: Environment this ELB lives in; determines ELB name and DNS entry that points to the ELB
* `service`: Service that this ELB sits in front of (e.g. `graphite-web`, `my-cool-http-api`, etc)
* `lb_port`: The port which the ELB listens on.
* `instance_port`: The destination port on the backend instance.
* `protocol`: The protocol (e.g. `http`, `https`, `tcp`, etc)
* `subnets` (list): The subnets (and thus availability zones) that this ELB should exist in
* `security_groups` (list): Security groups to apply to the ELB
* `instances` (list): List of instance ID's; puts these instances behind the ELB

#### Optional
* `region`: Region to provision the ELB in, defaults to `us-west-2`

### What's Generated

* An ELB named `$service-$environment-elb`
* A DNS record for `$service.$environment_shortname.us-west2.justin.tv` pointing to the ELB
   * `$environment_shortname` is `prod`, `dev`, or `staging` for `production`, `development`, and `staging`, respectively
