# Use twitch-aws for DNS purposes
provider "aws" {
  alias = "twitch-aws"
  region = "us-west-2"
  profile = "twitch-aws"
}

provider "aws" {
  alias = "${var.account}"
  region = "${var.region}"
  profile = "${var.account}"
}

# ELB
resource "aws_elb" "elb" {
  provider = "aws.${var.account}"
  name = "${var.service}-${var.environment}-elb"
  internal = true
  listener {
    instance_port = "${var.instance_port}"
    instance_protocol = "${var.protocol}"
    lb_port = "${var.lb_port}"
    lb_protocol = "https"
    ssl_certificate_id = ""
  }
  tags {
    Name = "${var.service}-${var.environment}-elb"
  }
  subnets = ["${var.subnets}"]
  security_groups = ["${var.security_groups}"]
  instances = ["${var.instances}"]
}

# DNS FOR ELB
resource "aws_route53_record" "elb_dns" {
  provider = "aws.twitch-aws"
  zone_id = "ZRG00SM48517Z" # harcoded twitch-aws zone-id
  name = "${var.service}.${lookup(var.env_shortname, var.environment)}.us-west2.justin.tv"
  type = "A"

  alias {
    name = "${aws_elb.elb.dns_name}"
    zone_id = "${aws_elb.elb.zone_id}"
    evaluate_target_health = false
  }
}
