resource "aws_autoscaling_group" "asg" {
  name = "frankenjoin-${var.twitch_environment}"
  launch_configuration = "${aws_launch_configuration.app.name}"
  
  max_size = "1"
  min_size = "0"
  desired_capacity = "1"
  
  vpc_zone_identifier = ["${split(",", "${var.subnet_id}")}"]
  
  tag {
    key = "Name"
    value = "frankenjoin-${var.twitch_environment}"
    propagate_at_launch = true
  }
  
  tag {
    key = "Owner"
	value = "${var.owner_tag}"
	propagate_at_launch = true
  }
  
  tag {
    key = "Project"
	value = "${var.project_tag}"
	propagate_at_launch = true
  }
  
  tag {
    key = "twitch_environment"
	value = "${var.twitch_environment}"
	propagate_at_launch = true
  }
}

output "asg_name" {
    value = "${aws_autoscaling_group.asg.id}"
}
