variable "environment" {
    default = "production"
}

variable "team" {
    default = "data-eng"
}

variable "aws_account" {
    default = "twitch-web-aws"
}

module "common" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/variables/twitch-web-aws"
}

module "asg" {
    source = "../lib/frankenjoin.20170221/"

    subnet_id = "${module.common.service_a},${module.common.service_b},${module.common.service_c}"
    security_groups = "${module.common.twitch_subnets}"
    twitch_environment = "${var.environment}"
    aws_account = "${var.aws_account}"
}

provider "aws" {
    region = "us-west-2"
    profile = "${var.aws_account}"
}

module "notifications_route53" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/asg-r53-lambda.git//modules/notifications"
  aws_profile = "twitch-aws"
  topic_name = "frankenjoin_r53_${var.team}_${var.environment}"
  asg_name = "${module.asg.asg_name}"
  lambda_arn = "arn:aws:lambda:us-west-2:641044725657:function:asg_route53_update"
}
