#!/bin/bash

DIRECTORY=$1
OWNER=$2
SERVICE=$3
BUCKET=${4:-"$OWNER-deploy"}

cd $DIRECTORY
tar -czf /tmp/$BUILD_TAG-$GIT_COMMIT.tgz .
aws s3 --profile deploy cp /tmp/$BUILD_TAG-$GIT_COMMIT.tgz s3://$BUCKET/$OWNER/$SERVICE/$GIT_COMMIT.tgz
artifact_size=$(wc -c < /tmp/$BUILD_TAG-$GIT_COMMIT.tgz)
echo -n "jenkins.job.$JOB_NAME:$artifact_size|g" | nc -u -w 1 statsd.internal.justin.tv 8125 || true
rm /tmp/$BUILD_TAG-$GIT_COMMIT.tgz
