Resource Usage:
---------------

This is a single-threaded Python program, but it forks pgBadger as
a separate process. You can expect it to peg one of your cores all the time,
and two of your cores some of the time. However, it uses negligible memory.

Requirements:
-------------

1. Make sure there is passwordless, localhost access to PostgreSQL from a superuser.

1. Be sure the prerequisites are installed (the script will complain
   if they are not); the prerequisites are listed below.
   
1. Create a directory to contain the files:

    project/logs -- All log files here.  They can be .csv or .csv.gz, but not a mix.
    
    project/sar -- All sar files here.  They need to be named *.sar.txt.
    
    project/monitor/ -- The copy files for the database data; it needs
        to have this name.
    
    project/settings.py -- The settings file.  You can use settings-sample.py
       (renamed, of course) as the template. See the comments in that file
       for further directions.
       
1. cd to the top level of the project directory

1. Start a screen or tmux session if you can, as the process typically takes a few hours.

1. Run the script with:

    path/to/healthcheck/Tuneup/health_check
    
    It doesn't need to be on your path.  It should set the PYTHONPATH and other
    stuff, and start the run.

Prerequisites:
--------------

Python 2.6 or 2.7

The following can be installed using pip:

        pip install numpy
        pip install -r requirements.txt

We generally recommend running inside a virtualenv:

        virtualenv ~/phc_env
        . ~/phc_env/bin/activate
        pip install numpy
        pip install -r requirements.txt
        ~/git/Tuneup/health_check
