SECTIONS = {
    'cpu':      { 'CPU':        ( 'cpu', 's', True ),
                  '%usr':       ( 'peruser', 'n' ),
                  '%user':      ( 'peruser', 'n' ),
                  '%nice':      ( 'pernice', 'n' ),
                  '%system':    ( 'persystem', 'n' ),
                  '%sys':       ( 'persys', 'n' ),
                  '%iowait':    ( 'periowait', 'n' ),
                  '%steal':     ( 'persteal', 'n' ),
                  '%irq':       ( 'perirq', 'n' ),
                  '%soft':      ( 'persoft', 'n' ),
                  '%guest':     ( 'perguest', 'n' ),
                  '%idle':      ( 'peridle', 'n'),
                },
    'disk':     { 'DEV':        ( 'dev', 's', True ),
                  'tps':        ( 'tps', 'n' ),
                  'rd_sec/s':   ( 'rd_sec_s', 'n' ),
                  'wr_sec/s':   ( 'wr_sec_s', 'n' ),
                  'avgrq-sz':   ( 'avgrq_s', 'n' ),
                  'avgqu-sz':   ( 'avgqu_s', 'n' ),
                  'await':      ( 'await', 'n' ),
                  'svctm':      ( 'svctm', 'n' ),
                  '%util':      ( 'perutil', 'n' ),
                },
    'load':     { 'runq-sz':    ( 'runq_sz', 'n'),
                  'plist-sz':   ( 'plist_sz', 'n'),
                  'ldavg-1':    ( 'ldavg_1', 'n'),
                  'ldavg-5':    ( 'ldavg_5', 'n'),
                  'ldavg-15':   ( 'ldavg_15', 'n'),
                  'blocked':    ( 'blocked', 'n'),
                },
    'memory':   { 'kbmemfree':  ( 'kbmemfree', 'n' ),
                  'kbmemused':  ( 'kbmemused', 'n' ),
                  '%memused':   ( 'permemused', 'n' ),
                  'kbbuffers':  ( 'kbbuffers', 'n' ),
                  'kbcached':   ( 'kbcached', 'n' ),
                  'kbswpfree':  ( 'kbswpfree', 'n' ),
                  'kbswpused':  ( 'kbswpused', 'n' ),
                  '%swpused':   ( 'perswpused', 'n' ),
                  'kbswpcad':   ( 'kbswpcad', 'n' ),
                },
    'paging':    { 'pgpgin/s':       ( 'pg_in_s', 'n' ),
                  'pgpgout/s':      ( 'pg_out_s', 'n' ),
                  'fault/s':      ( 'fault_s', 'n' ),
                  'majflt/s':      ( 'mag_flt_s', 'n' ),
                  'pgfree/s':      ( 'pg_free_s', 'n' ),
                  'pgscank/s':      ( 'pg_scan_kswd_s', 'n' ),
                  'pgscand/s':      ( 'pg_scan_s', 'n' ),
                  'pgsteal/s':      ( 'pg_stl_s', 'n' ),
                  '%vmeff':      ( 'vmeff', 'n' ),
                },
    'cswch':    { 'proc/s':       ( 'proc', 'n' ),
                  'cswch/s':      ( 'cswch', 'n' )
                },
            }

TABLES = {
    'cpu':      'cpu',
    'disk':     'disk',
    'load':     'load',
    'memory':   'memory',
    'cswch':    'cswch',
    'paging':   'paging'
    }

def determine_section(columns):
    for section_name, section in SECTIONS.iteritems():
        columns_found = 0
        for column in columns:
            if column in section.keys():
                columns_found += 1
                if columns_found >= 2:
                    return ( section_name, section )
                elif section_name == 'cswch' and (column == 'proc/s' or column == 'cswch/s'):
                    return ( section_name, section )
    
    return ( None, None, )
