import preflight

import os
import sys

from config.settings import *
from settings import *
import shutil

import util.db
from util.log import log
import loaders, loaders.load_logs, loaders.load_sar, loaders.load_monitor
import reports
import reports.cpu
import reports.memory
import reports.io
import reports.temp_files
import reports.tables
import reports.tables_all
import reports.bloat
import reports.connections
import reports.statements
import reports.checkpoints
import reports.indexes
import reports.database
import reports.replication
import reports.pgfouine
import reports.pgbadger
import reports.context_switch


#

if not os.path.exists(REPORT_DIR_PATH):
    os.makedirs(REPORT_DIR_PATH)
else:
    if os.path.exists(REPORT_DIR_PATH + "/table-growth"):
        shutil.rmtree(REPORT_DIR_PATH + "/table-growth")
    if os.path.exists(REPORT_DIR_PATH + "/table-sizes"):
        shutil.rmtree(REPORT_DIR_PATH + "/table-sizes")
    if os.path.exists(REPORT_DIR_PATH + "/tuples-read"):
        shutil.rmtree(REPORT_DIR_PATH + "/tuples-read")
    if os.path.exists(REPORT_DIR_PATH + "/tuples-written"):
        shutil.rmtree(REPORT_DIR_PATH + "/tuples-written")

log_processor = None


if PROCESS_LOGS:
    try:
        PGFOUINE_PATH
        log_processor = reports.pgfouine.start_pg_fouine()
    except NameError:
        try:
            PGBADGER_PATH
            log_processor = reports.pgbadger.start_pgbadger()
        except NameError:
            pass
            
util.db.create_project_database()
util.db.create_project_tables()

if PROCESS_MONITOR:
    loaders.load_monitor.load_monitor()

if PROCESS_SAR:
    loaders.load_sar.load_sar()

if PROCESS_LOGS:
    loaders.load_logs.load_logs()

#preflight.postflight.postflight()

log('Preprocessing.')

reports.preprocess()

if PROCESS_SAR:
    log('CPU reports.')

    reports.cpu.average_cpu()
    reports.cpu.busiest_core()
    reports.cpu.busy_cores()
    reports.cpu.runq_loadavg()
    reports.context_switch.context_switch()

    log('Memory reports.')

    reports.memory.ram_usage()
    reports.memory.swap_usage()

    log('I/O reports.')

    reports.io.disk_activity()
    reports.io.service_wait()
    reports.io.io_wait()
    reports.io.tps_activity()
    reports.io.paging()

if PROCESS_LOGS:
    log('Temp file reports.')
    
    reports.temp_files.temp_files()
    reports.temp_files.temp_files_by_time()

if PROCESS_MONITOR:
    log('Table size reports.')
    
    reports.tables.table_sizes()
    reports.tables.table_growth()
    reports.tables.tuples_read()
    reports.tables.tuples_written()

    reports.tables_all.table_sizes_all()
    reports.tables_all.table_growth_all()
    reports.tables_all.tuples_read_all()
    reports.tables_all.tuples_written_all()

if PROCESS_LOGS and PROCESS_MONITOR:
    log('Connection reports.')
    
    reports.connections.connections_by_minute()
    reports.connections.connections_per_minute()

if PROCESS_LOGS:
    log('Statement reports.')
    
    reports.statements.statements_per_second()
    reports.statements.statement_durations_by_time()

if PROCESS_LOGS and PROCESS_MONITOR:
    log('Checkpoint reports.')
    
    reports.checkpoints.checkpoint_activity()
    reports.checkpoints.checkpoint_detail()

if PROCESS_MONITOR:
    log('Database reports.')

    reports.database.database_data()
    reports.database.conflicts()
    reports.database.queries_app_name()
    reports.database.database_size()

if PROCESS_MONITOR:
    log('Index reports.')
    
    reports.indexes.needed_indexes_run()
    reports.indexes.needed_indexes_all()
    reports.indexes.unused_indexes()
    reports.indexes.duplicate_indexes()

if PROCESS_MONITOR:
    log('Bloat reports.')

    reports.bloat.bloated_indexes()
    reports.bloat.bloated_tables()

if PROCESS_MONITOR:
    log('Replication reports.')

    reports.replication.replication()


if log_processor and log_processor.is_alive():
    log('Waiting for log processor to to complete.')
    log_processor.join()

log('Done!')
