from config.settings import *
from settings import *
import util.db
from util.log import log

def postflight():
    db = util.db.connect()
    
    sar_devices = [ ]
    
    for name, devices in DEVICES.iteritems():
        for sar_device in devices:
            if sar_device not in sar_devices:
                sar_devices.append(sar_device)
    
    sar_devices = set(sar_devices)
    
    cur = db.cursor()
    
    cur.execute("""
        SELECT DISTINCT dev
            FROM disk
        """ )
    
    measured = set([ t[0] for t in cur.fetchall() ])

    not_in_config = measured.difference(sar_devices)
    
    if not_in_config:
        log("sar devices for which measurements were recorded, but are not in config: " +
            ', '.join(not_in_config) )
    
    not_measured = sar_devices.difference(measured)
    
    if not_measured:
        log("sar devices in config, for which no measurements were found: " +
            ', '.join(not_measured) )
    
    