import sys

from config.settings import *
from settings import *
import util.db
from util.log import log
from os import path
import csv, re

def preprocess():
    connection = util.db.connect()
    
    util.db.set_transaction_mode(connection, transactions_on=False)
    
    util.db.analyze(connection)

    util.db.set_transaction_mode(connection, transactions_on=True)

    cur = connection.cursor()

    log("create_time_boundaries()")
    cur.execute("SELECT * FROM create_time_boundaries()")
    connection.commit()

    log("create_log_minutes()")
    cur.execute("SELECT * FROM create_log_minutes()")
    connection.commit()

    log("create_temp_file_table()")
    cur.execute("SELECT * FROM create_temp_file_table()")
    connection.commit()
    
    # log("lock_hunting()")
    # cur.execute("SELECT * FROM lock_hunting()")
    # connection.commit()
    
    log("create_connection_tables()")
    cur.execute("SELECT * FROM create_connection_tables()")
    connection.commit()
    
    log("create_statements()")
    cur.execute("SELECT * FROM create_statements()")
    connection.commit()
    
    log("create_statements_per_minute()")
    cur.execute("SELECT * FROM create_statements_per_minute()")
    connection.commit()
    
    if PROCESS_MONITOR:
        log("create_checkpoints()")
        cur.execute("SELECT * FROM create_checkpoints()")
        connection.commit()
    
    cur.close()
    
    util.db.analyze(connection)
        
    connection.close()


def text_report(cur, filename):
    exists = False
    if path.exists(filename):
        exists = True
    with open(filename, 'a') as rfile:
        fwriter = csv.writer(rfile,delimiter='\t',quoting=csv.QUOTE_NONNUMERIC)
        if not exists:
            fwriter.writerow([desc[0] for desc in cur.description])
        for record in cur.fetchall():
            fwriter.writerow([s for s in record])
