import subprocess

import numpy as np
import matplotlib
from matplotlib.font_manager import FontProperties
from matplotlib.ticker import MultipleLocator
from matplotlib import dates

import psycopg2

from config.settings import *
from settings import *
import util.db
import reports.times
from util.log import log


matplotlib.use('Agg')

def connections_by_minute():
    import matplotlib.pyplot as plot
    db = util.db.connect()

    cur = db.cursor()

    cur.execute("""
        SELECT *
            FROM connections_by_minute()
            WHERE measurement_time BETWEEN %(start_time)s AND %(end_time)s
            ORDER BY measurement_time
        """, reports.times.log_range())

    results = cur.fetchall()

    if not results:
        no_file = REPORT_DIR_PATH + '/connections_by_minute.txt'
        with open(no_file, 'w') as no_results:
            no_results.write("No results.")
        no_results.close()
        log('No connections recorded; skipping connections-by-minute report')
        return

    timeseries = [r[0] for r in results]
    connections = [r[1] for r in results]

    fig = plot.figure(figsize=DEFAULT_FIGURE_SIZE)
    ax = fig.add_subplot(111, axisbg='#fafafa', alpha=0.9)
    hfmt = dates.DateFormatter('%H:%M:%S')

    ax.set_title('Connections Over Time')
    ax.set_ylabel('connections')
    ax.xaxis.set_major_formatter(hfmt)
    ax.set_xlim(xmin=reports.times.log_start(), xmax=reports.times.log_end())
    ax.grid(True)

    ax.plot(timeseries, connections, color='blue', label='Connections')

    fig.autofmt_xdate()

    plot.savefig(REPORT_DIR_PATH + '/connections_by_minute.pdf')

    plot.close()


def connections_per_minute():
    import matplotlib.pyplot as plot

    db = util.db.connect()
    
    cur = db.cursor()
    
    cur.execute("""
        SELECT date_trunc('minute', log_time) AS measurement_time, count(*) 
            FROM connections
            WHERE log_time BETWEEN %(start_time)s AND %(end_time)s
            GROUP BY 1
            ORDER BY measurement_time
        """, reports.times.log_range())

    results = cur.fetchall()
    
    if not results:
        no_file = REPORT_DIR_PATH + '/connections_per_minute.txt'
        with open(no_file, 'w') as no_results:
            no_results.write("No results.")
        no_results.close()
        log('No connections recorded; skipping connections-per-minute report')
        return
        
    timeseries = [r[0] for r in results]
    connections = [r[1] for r in results]

    fig = plot.figure(figsize=DEFAULT_FIGURE_SIZE)
    ax = fig.add_subplot(111, axisbg='#fafafa', alpha=0.9)
    hfmt = dates.DateFormatter('%H:%M:%S')

    ax.set_title('Connections Per Minute')
    ax.set_ylabel('connections made')
    ax.xaxis.set_major_formatter(hfmt)
    ax.set_xlim(xmin=reports.times.log_start(), xmax=reports.times.log_end())
    ax.grid(True)

    ax.plot(timeseries, connections, color='red', label='Connections')

    fig.autofmt_xdate()
    
    plot.savefig(REPORT_DIR_PATH + '/connections_per_minute.pdf')

    plot.close()


