import matplotlib
from matplotlib.font_manager import FontProperties
from matplotlib import dates

import psycopg2

from config.settings import *
from settings import *
import util.db
import reports.times
from util.log import log

matplotlib.use('Agg')
    
def context_switch():
    
    import matplotlib.pyplot as plot
    
    db = util.db.connect()
    
    cur = db.cursor()
    
    cur.execute("""
        SELECT measurement_time, proc, cswch
            FROM cswch 
            WHERE measurement_time BETWEEN %(start_time)s AND %(end_time)s
            ORDER BY measurement_time
        """, reports.times.sar_range())
    
    results = cur.fetchall()

    if not results:
        no_file = REPORT_DIR_PATH + '/context_switch.txt'
        with open(no_file, 'w') as no_results:
            no_results.write("No results.")
        no_results.close()
        log('No data recorded; skipping context_switch report')
        return
    
    timeseries = [r[0] for r in results]
    proc = [r[1] for r in results]
    cswch = [r[2] for r in results]
    
    fig = plot.figure(figsize=DEFAULT_FIGURE_SIZE)
    ax1 = fig.add_subplot(111, axisbg='#fafafa', alpha=0.9)
    hfmt = dates.DateFormatter('%H:%M:%S')

    small_font = FontProperties()
    small_font.set_size('small')
    
    ax1.set_title('Context switches and process creation per second')
    
    ax1.set_ylabel('cswch/s', color='red')
    
    ax1.grid(True)
    ax1.xaxis.set_major_formatter(hfmt)
    ax1.set_xlim(xmin=reports.times.sar_start(), xmax=reports.times.sar_end())

    ln1 = ax1.plot(timeseries, cswch, color='red', label='cswch/s')

    ax2 = ax1.twinx()

    ln2 = ax2.plot(timeseries, proc, color='blue', linestyle=':', label='proc/s')

    ax2.set_ylabel('proc/s', color='blue')

    ax2.set_xlim(xmin=reports.times.sar_start(), xmax=reports.times.sar_end())

    lns = ln1+ln2
    labs = [l.get_label() for l in lns]
    lgnd = ax1.legend(lns, labs, loc=0)

    fig.autofmt_xdate()
    
    plot.savefig(REPORT_DIR_PATH + '/context_switch.pdf', bbox_inches='tight', pad_inches=0.25, bbox_extra_artists=[lgnd])

    plot.close()

if __name__ == "__main__":
    context_switch()
    
