# import math
#
# import numpy as np
# import matplotlib
# from matplotlib.font_manager import FontProperties
# from matplotlib.ticker import MultipleLocator
# import psycopg2
#
# from config.settings import *
# from settings import *
# import util.db
# from util.log import log
# import reports.times
#
# matplotlib.use('Agg')
#
# def lock_grants():
#     import matplotlib.pyplot as plot
#
#     db = util.db.connect()
#
#     cur = db.cursor()
#
#     cur.execute("""
#         SELECT date_trunc('minute', log_time) AS log_time,
#                COUNT(*) AS lock_count,
#                SUM(wait_time)
#             FROM lock_grants
#             WHERE log_time BETWEEN %(start_time)s AND %(end_time)s
#             GROUP BY 1
#             ORDER BY log_time
#         """, reports.times.log_range())
#
#     results = cur.fetchall()
#
#     timeseries = [r[0] for r in results]
#     grants = [r[1] for r in results]
#     wait_time_size = [2*int(round(math.log10(float(r[2])))) for r in results]
#
#     if not grants:
#         log("No lock records, so no lock report generated.")
#         return
#
#     max_grants = max(grants)
#
#     if max_grants == 0:
#         log("No lock records, so no lock report generated.")
#         return
#
#     tick_base = int(math.pow(10, math.trunc(math.log10(float(max_grants)))))
#
#     fig = plot.figure(figsize=DEFAULT_FIGURE_SIZE)
#     ax = fig.add_subplot(111, axisbg='#fafafa', alpha=0.9)
#
#     ax.set_title('Lock Grants per Minute')
#     ax.set_ylabel('Grants')
#     ax.set_xlim(xmin=reports.times.log_start(), xmax=reports.times.log_end())
#     ax.set_ylim(ymin=0, ymax=max_grants+1)
#     ax.grid(True)
#
#     ax.yaxis.set_major_locator(MultipleLocator(tick_base))
#
#     ax.scatter(timeseries, grants, s=wait_time_size, color='blue', label='Grants')
#
#     fig.autofmt_xdate()
#
#     plot.savefig(REPORT_DIR_PATH + '/lock_grants.pdf')
#
#     plot.close()
