import util.db
from settings import *

from datetime import datetime
import time, pytz


sar_start_time = None
sar_end_time = None
log_start_time = None
log_end_time = None


def populate():
    global sar_start_time
    global sar_end_time
    global log_start_time
    global log_end_time

    db = util.db.connect()
    
    cur = db.cursor()
    
    cur.execute("""
        SELECT sar_start, sar_end, log_start, log_end FROM time_boundaries LIMIT 1;
    """)
    
    times = cur.fetchone()
    current_tz= pytz.timezone(TIMEZONE)
    if SPECIFIED_START_TIME and SPECIFIED_START_DATE:
        sar_start_time = datetime.fromtimestamp(time.mktime(time.strptime(SPECIFIED_START_DATE + ', '+ SPECIFIED_START_TIME, "%Y, %m, %d, %H, %M, %S")), tz=current_tz)
        log_start_time = datetime.fromtimestamp(time.mktime(time.strptime(SPECIFIED_START_DATE + ', '+ SPECIFIED_START_TIME, "%Y, %m, %d, %H, %M, %S")), tz=current_tz)
    else:
        sar_start_time = times[0]
        log_start_time = times[2]

    if SPECIFIED_END_TIME and SPECIFIED_END_DATE:
        sar_end_time = datetime.fromtimestamp(time.mktime(time.strptime(SPECIFIED_END_DATE + ', '+ SPECIFIED_END_TIME, "%Y, %m, %d, %H, %M, %S")), tz=current_tz)
        log_end_time = datetime.fromtimestamp(time.mktime(time.strptime(SPECIFIED_END_DATE + ', '+ SPECIFIED_END_TIME, "%Y, %m, %d, %H, %M, %S")), tz=current_tz)
    else:
        sar_end_time = times[1]
        log_end_time = times[3]

    # sar_start_time = times[0]
    # sar_end_time = times[1]
    # log_start_time = times[2]
    # log_end_time = times[3]

    db.close()


def sar_start():
    if sar_start_time is None:
        populate()

    return sar_start_time


def sar_end():
    if sar_end_time is None:
        populate()

    return sar_end_time

def graph_sar_start():
    if sar_start_time is None:
        populate()
    sar_start = sar_start_time.replace(tzinfo=None)
    # sar_start = sar_start - datetime.timedelta(seconds=sar_start.second%60)
    #
    # sar_start = sar_start - datetime.timedelta(minutes=sar_start.minute %5)
    return sar_start


def graph_sar_end():
    if sar_end_time is None:
        populate()
    sar_end = sar_end_time.replace(tzinfo=None)
    return sar_end


def sar_range(other_parms=None):
    parms = { 'start_time': sar_start(), 'end_time': sar_end() }

    if other_parms is not None:
        for k, v in other_parms.iteritems():
            parms[k] = v
    
    return parms


def log_start():
    if log_start_time is None:
        populate()
    
    return log_start_time


def log_end():
    if log_end_time is None:
        populate()
    
    return log_end_time


def log_range(other_parms=None):
    parms = { 'start_time': log_start(), 'end_time': log_end() }

    if other_parms is not None:
        for k, v in other_parms.iteritems():
            parms[k] = v
    
    return parms
