from config.settings import *

PROJECTNAME = 'project'  # Simple name; used for the database role and db name
TIMEZONE = 'US/Pacific'  # Time zone the sar and log files are in; use 'UTC' for, well UTC.

PROCESS_LOGS = True      # Set to False to skip log processing

PROCESS_MONITOR = True   # Set to False to skip processing database data

PROCESS_SAR = True       # Set to False to skip sar data processing

#Allows you to specify your start or end date. You do not need to specify a start and end time but if you specify one you
#must also specify the corresponding date. The date in times should be the date and time you want the data collected from, this
#means the date of the run and the time related to the timezone of the client's box. If you leave it at None (the default),
#all the data in the tuneup with be processed, ie the full run.

SPECIFIED_START_DATE = None  #should be in the format 'YYYY, MM, DD'; None for default
SPECIFIED_START_TIME = None #should be in the format 'HH, MM, SS'; None for default
SPECIFIED_END_DATE = None #should be in the format 'YYYY, MM, DD'; None for default
SPECIFIED_END_TIME =   None #should be in the format 'HH, MM, SS'; None for default

# This maps sar device names to more useful names.  For soft RAID devices, list the
# components of the RAID rather than top-level device.
# You can find these by looking in /dev and matching up the partition with its
# parent device's major/minor numbers.  For example, if you have root mounted
# on /dev/sda2, then you would:
# ls -l /dev/sda
# and see this:
# brw-rw---- 1 root disk 8, 0 Jan  3 15:24 /dev/sda
# then the dev you would use below would be:
# 'sda': ('dev8-0', ),
# The 'nice' name of the device should not include any directory separate characters
# ( / \ : ), as it will be appended to the filename of certain reports.

DEVICES = {
    'md0':      ( 'dev8-80', 'dev8-96', 'dev8-112', 'dev8-128', ),
}

# If using pgfouine, specify the path to the .php file.  If using
# pgbadger, specify the path to the executable.

#PGFOUINE_PATH = 'path/to/pgfouine-1.2'

#PGFOUINE_REPORT_PATH = REPORT_DIR_PATH + '/' + PROJECTNAME + '.html'
#PGFOUINE_ERROR_PATH = REPORT_DIR_PATH + '/' + PROJECTNAME + '-pgfouine-errors.txt'

#PGBADGER_PATH = 'path/to/pgbadger'

#PGBADGER_REPORT_PATH = REPORT_DIR_PATH + '/' + PROJECTNAME + '.html'
#PGBADGER_ERROR_PATH = REPORT_DIR_PATH + '/' + PROJECTNAME + '-pgbadger-errors.txt'

# Additional options for pgbadger.  Each option needs to be a tuple
# element; don't string them all together as a single string.
# Example: --nocomment --top 50 --exclude-query ^(SET|DISCARD|BEGIN|COMMIT)
# Becomes:
#PGBADGER_OPTIONS = ( '--nocomment', '--top', '50', '--exclude-query', '^(SET|DISCARD|BEGIN|COMMIT)' )
   
# Less common options below this line.

SUPERUSER = 'postgres'

# You shouldn't have to edit below this line.

DBUSER = PROJECTNAME
DBNAME = PROJECTNAME
DBHOST = None
DBPORT = None

#

