BEGIN;

DROP TABLE IF EXISTS cpu;

CREATE TABLE cpu (
    measurement_time        TIMESTAMP WITH TIME ZONE NOT NULL,
    cpu                     VARCHAR(3) NOT NULL,
    
    peruser                 NUMERIC,
    pernice                 NUMERIC,
    persystem               NUMERIC,
    persys                  NUMERIC,
    periowait               NUMERIC,
    persteal                NUMERIC,
    perirq                  NUMERIC,
    persoft                 NUMERIC,
    perguest                NUMERIC,
    peridle                 NUMERIC,
    
    PRIMARY KEY(measurement_time, cpu)
);

DROP TABLE IF EXISTS disk;

CREATE TABLE disk (
    measurement_time        TIMESTAMP WITH TIME ZONE NOT NULL,
    dev                     TEXT NOT NULL,
    
    tps                     NUMERIC,
    rd_sec_s                NUMERIC,
    wr_sec_s                NUMERIC,
    avgrq_s                 NUMERIC,
    avgqu_s                 NUMERIC,
    await                   NUMERIC,
    svctm                   NUMERIC,
    perutil                 NUMERIC,
    
    PRIMARY KEY(measurement_time, dev)
);

DROP TABLE IF EXISTS paging;

CREATE TABLE paging (
    measurement_time        TIMESTAMP WITH TIME ZONE NOT NULL,
    pg_in_s                 NUMERIC,
    pg_out_s                NUMERIC,
    fault_s                NUMERIC,
    mag_flt_s               NUMERIC,
    pg_free_s               NUMERIC,
    pg_scan_kswd_s          NUMERIC,
    pg_scan_s               NUMERIC,
    pg_stl_s                NUMERIC,
    vmeff                   NUMERIC,

    PRIMARY KEY(measurement_time)
);

DROP TABLE IF EXISTS load;

CREATE TABLE load (
    measurement_time        TIMESTAMP WITH TIME ZONE NOT NULL,

    runq_sz                 NUMERIC,
    plist_sz                NUMERIC,
    ldavg_1                 NUMERIC,
    ldavg_5                 NUMERIC,
    ldavg_15                NUMERIC,
    blocked                 NUMERIC,

    PRIMARY KEY(measurement_time)
);



DROP TABLE IF EXISTS memory;

CREATE TABLE memory (
    measurement_time        TIMESTAMP WITH TIME ZONE NOT NULL,
    
    kbmemfree               NUMERIC,
    kbmemused               NUMERIC,
    permemused              NUMERIC,
    kbbuffers               NUMERIC,
    kbcached                NUMERIC,
    kbswpfree               NUMERIC,
    kbswpused               NUMERIC,
    perswpused              NUMERIC,
    kbswpcad                NUMERIC,

    PRIMARY KEY(measurement_time)
);

DROP TABLE IF EXISTS cswch;

CREATE TABLE cswch (
    measurement_time        TIMESTAMP WITH TIME ZONE NOT NULL,
    
    proc                    NUMERIC,
    cswch                   NUMERIC,

    PRIMARY KEY(measurement_time)
);
COMMIT;
