BEGIN;

DROP FUNCTION IF EXISTS disk_activity(OUT TIMESTAMP WITH TIME ZONE,
                                      OUT NUMERIC,
                                      OUT NUMERIC);

CREATE FUNCTION disk_activity(OUT measurement_time TIMESTAMP WITH TIME ZONE,
                              OUT dev TEXT,
                              OUT mb_rd_sec NUMERIC,
                              OUT mb_wr_sec NUMERIC) RETURNS SETOF RECORD AS
$disk_activity$
BEGIN

    RETURN QUERY
        SELECT disk.measurement_time,
               disk.dev,
               disk.rd_sec_s / 2048 AS mb_rd_sec,
               disk.wr_sec_s / 2048 AS mb_wr_sec
            FROM disk
            ORDER BY disk.measurement_time;

END;
$disk_activity$
    LANGUAGE 'plpgsql';

DROP FUNCTION IF EXISTS io_wait(OUT TIMESTAMP WITH TIME ZONE,
                                OUT NUMERIC,
                                OUT NUMERIC);

CREATE FUNCTION io_wait(OUT measurement_time TIMESTAMP WITH TIME ZONE,
                        OUT avg_io_wait NUMERIC,
                        OUT max_io_wait NUMERIC) RETURNS SETOF RECORD AS
$io_wait$
BEGIN

    RETURN QUERY
        SELECT cpu.measurement_time,
               cpu.periowait AS avg_io_wait,
               max_cpu.max_io_wait
            FROM cpu
            JOIN (
                SELECT cpu.measurement_time,
                       MAX(cpu.periowait) AS max_io_wait
                    FROM cpu
                    WHERE cpu.cpu <> 'all'
                    GROUP BY cpu.measurement_time
                ) AS max_cpu USING (measurement_time)
            WHERE cpu.cpu = 'all'
            ORDER BY cpu.measurement_time;
                         
END;
$io_wait$
    LANGUAGE 'plpgsql';

COMMIT;