BEGIN;

DROP FUNCTION IF EXISTS create_temp_file_table();

CREATE FUNCTION create_temp_file_table() RETURNS VOID AS
$create_temp_file_table$
BEGIN

    DROP TABLE IF EXISTS temp_files;
    
    CREATE TABLE temp_files AS
        SELECT log_time AS measurement_time,
               CAST(SUBSTRING(message FROM $x$size (\d+)$x$) AS NUMERIC) as file_size
            FROM postgres_log
            WHERE message LIKE 'temporary file%';

END;
$create_temp_file_table$
    LANGUAGE 'plpgsql';

COMMIT;