BEGIN;

DROP FUNCTION IF EXISTS table_sizes(OUT table_name TEXT,
                                    OUT data_size BIGINT,
                                    OUT index_toast_size BIGINT,
                                    OUT total_size BIGINT);

CREATE FUNCTION table_sizes(OUT table_name TEXT,
                            OUT data_size BIGINT,
                            OUT index_toast_size BIGINT,
                            OUT total_size BIGINT) RETURNS SETOF RECORD AS
$table_sizes$
BEGIN

    RETURN QUERY 
        SELECT pretty_table_name(tse.schemaname, tse.relname) AS table_name,
               tse.pg_relation_size AS data_size,
               tse.pg_total_relation_size - tse.pg_relation_size AS index_toast_size,
               tse.pg_total_relation_size AS total_size
            FROM table_size_end AS tse;

END;
$table_sizes$
    LANGUAGE 'plpgsql';

DROP FUNCTION IF EXISTS table_growth(OUT table_name TEXT,
                                     OUT growth DOUBLE PRECISION);

CREATE FUNCTION table_growth(OUT table_name TEXT,
                             OUT growth DOUBLE PRECISION) RETURNS SETOF RECORD AS
$table_sizes$
BEGIN

    RETURN QUERY 
        SELECT pretty_table_name(tse.schemaname, tse.relname) AS table_name,
               (tse.pg_total_relation_size - COALESCE(tss.pg_total_relation_size,0))/run_hours() AS table_growth
            FROM table_size_end AS tse
            LEFT OUTER JOIN table_size_start AS tss USING(relid);

END;
$table_sizes$
    LANGUAGE 'plpgsql';

DROP FUNCTION IF EXISTS table_activity(OUT table_name TEXT,
                                       OUT tuples_read BIGINT,
                                       OUT tuples_written BIGINT,
                                       OUT tuples_inserted BIGINT,
                                       OUT tuples_updated BIGINT,
                                       OUT tuples_deleted BIGINT);

CREATE FUNCTION table_activity(OUT table_name TEXT,
                               OUT tuples_read BIGINT,
                               OUT tuples_written BIGINT,
                               OUT tuples_inserted BIGINT,
                               OUT tuples_updated BIGINT,
                               OUT tuples_deleted BIGINT) RETURNS SETOF RECORD AS
$table_sizes$
BEGIN

    RETURN QUERY 
        SELECT pretty_table_name(sute.schemaname, sute.relname) AS table_name,
               (sute.seq_tup_read - COALESCE(suts.seq_tup_read, 0)) +
               COALESCE(sute.idx_tup_fetch - COALESCE(suts.idx_tup_fetch, 0), 0) AS tuples_read,
               (sute.n_tup_ins - COALESCE(suts.n_tup_ins, 0)) +
               (sute.n_tup_upd - COALESCE(suts.n_tup_upd, 0)) +
               (sute.n_tup_del - COALESCE(suts.n_tup_del, 0)) +
               (sute.n_tup_hot_upd - sute.n_tup_hot_upd) AS tuples_written,
               sute.n_tup_ins - COALESCE(suts.n_tup_ins, 0) AS tuples_inserted,
               sute.n_tup_upd - COALESCE(suts.n_tup_upd, 0) AS tuples_updated,
               sute.n_tup_del - COALESCE(suts.n_tup_del, 0) AS tuples_deleted
           FROM pg_stat_user_tables_end AS sute
           LEFT OUTER JOIN pg_stat_user_tables_start AS suts USING(relid);

END;
$table_sizes$
    LANGUAGE 'plpgsql';

COMMIT;