import os
import sys
import glob
import subprocess

import psycopg2

from config.settings import *
from settings import *
from util.log import log


def does_user_exist(username, connection=None):
    if connection is None:
        connection =  connect(usertype='Super', transactions=False)

    cur = connection.cursor()

    cur.execute("SELECT COUNT(*) FROM pg_user WHERE usename=%(username)s", { 'username' : username } )

    count = cur.fetchone()[0]
    cur.close()

    return count > 0


def set_transaction_mode(connection, transactions_on):
    old_transactions_on = not connection.autocommit

    connection.autocommit = not transactions_on

    return old_transactions_on


def connect(usertype='Normal', transactions=True):
    if usertype == 'Super':
        connection_string = "dbname=%(dbname)s user=%(dbuser)s" % { 'dbname': 'postgres', 'dbuser': SUPERUSER }
    else:
        connection_string = "dbname=%(dbname)s user=%(dbuser)s" % { 'dbname': DBNAME, 'dbuser': DBUSER }

    if DBHOST is not None:
        connection_string = connection_string + " host=%(dbhost)s" % { 'dbhost': DBHOST }

    if DBPORT is not None:
        connection_string = connection_string + " port=%(dbport)s" % { 'dbport': DBPORT }

    connection = psycopg2.connect(connection_string)

    set_transaction_mode(connection, transactions_on=False)

    cur = connection.cursor()
    cur.execute("SET SESSION TIME ZONE %(tz)s", { 'tz': TIMEZONE } )

    set_transaction_mode(connection, transactions_on=transactions)

    cur.close()

    return connection


def create_project_database():
    connection = connect(usertype='Super', transactions=False)

    cur = connection.cursor()

    log("Creating database " + DBNAME)

    cur.execute("DROP DATABASE IF EXISTS %(dbname)s" %  { 'dbname': DBNAME } )

    cur.execute("CREATE DATABASE %(dbname)s" % { 'dbname': DBNAME } )

    if not does_user_exist(DBUSER, connection):
        cur.execute("CREATE USER %(dbuser)s" % { 'dbuser': DBUSER })

    cur.execute("GRANT ALL ON DATABASE %(dbname)s TO %(dbuser)s" % { 'dbname': DBNAME, 'dbuser': DBUSER } )

    cur.close()

    connection.close()


def analyze(connection):
    transactions_on = set_transaction_mode(connection, transactions_on=False)

    cur = connection.cursor()

    log("ANALYZE.")
    cur.execute("ANALYZE")

    cur.close()

    set_transaction_mode(connection, transactions_on=transactions_on)


def create_project_tables():
    sql_files = sorted(glob.glob(SQL_DIR_PATH + '/*.sql'))

    for sql_file in sql_files:
        options = [ 'psql', '-f', sql_file, '-U', DBUSER, ]

        if DBHOST is not None:
            options.append('-h')
            options.append(DBHOST)

        if DBPORT is not None:
            options.append('-p')
            options.append(DBPORT)

        options.append(DBNAME)

        if subprocess.call(options, stderr=subprocess.PIPE) != 0:
            return
