import math

from util import table_scale

def magnitude_ticks(value, index):
    value = abs(value)
    
    ( kmg, divisor ) = table_scale(value)
    
    if (value == 0) or (value >= 1):
        precision = 0
        if value%divisor != 0:
            precision += 1
    else:
        precision = min(4, -math.trunc(math.log10(value)))
        
    return (("%." + str(precision) +"f") % (value/divisor)) + kmg;