import re
import datetime
import pytz

def parse_file_header(sar_line):
    
    (month, day, year) = re.search('(\d\d)\/(\d\d)/(\d{2,4})', sar_line).groups()
    
    month = int(month)
    day = int(day)
    year = int(year)
    
    if (year < 1900):
        year += 2000
    
    return datetime.date(year, month, day)


def parse_sar_line(sar_line, current_date, current_tz):

    sar_line = sar_line.strip()
    
    match = re.match('(\d\d):(\d\d):(\d\d) (AM|PM|)\s+(.+)$', sar_line)
    
    if match is None:
        return ( None, None )
    
    (hours, minutes, seconds, ampm, value_portion) = match.groups()
    columns = re.split('\s+', value_portion)
    
    hours = int(hours)
    minutes = int(minutes)
    seconds = int(seconds)
    
    if (ampm == 'PM') and (hours < 12):
        hours += 12
    
    if (ampm == 'AM') and (hours == 12):
        hours = 0
    
    time_portion = datetime.time(hours, minutes, seconds)

    timestamp = datetime.datetime.combine(current_date, time_portion)

    timestamp = current_tz.localize(timestamp)

    return (timestamp, columns)

def parse_pg_statistic_start(number, variable, line):
    word = variable + str(number)
    while not word in line:
        number = number -1
        word = variable + str(number)
    return number